#include "editor.h"
Editor * editor;
void editor_new(void) {
    land_alloc(editor);
}
void editor_del(void) {
    land_free(editor);
    editor = NULL;
}
bool editor_click(LandFloat mx, LandFloat my, bool clicked, bool released) {
    if (clicked) {
        Block * p = blocks_pick(game->blocks, mx, my, game->viewport);
        if (! p) {
            editor->picked = NULL;
            return 0;
        }
        editor->mx = mx;
        editor->my = my;
        editor->ox = p->x;
        editor->oy = p->y;
        editor->oz = p->z;
        editor->picked = p;
        return 1;
    }
    else {
        if (editor->picked) {
            LandFloat dx = mx - editor->mx;
            LandFloat dy = my - editor->my;
            dx /= game->viewport->zoom;
            dy /= game->viewport->zoom;
            float ang = (atan2(dy * 2, dx) + pi) * 8 / 2 / pi;
            float r = sqrt(dx * dx + dy * dy);
            if (r < 12) {
                return 1;
            }
            dx += dx * (- 12 / r);
            dy += dy * (- 12 / r);
            Block * p = editor->picked;
            p->x = editor->ox;
            p->y = editor->oy;
            p->z = editor->oz;
            float s = 24;
            //       2
            //    1     3
            //  0    *    4
            //    7     5
            //       6
            if (fabs(ang - 2) < 0.5 || fabs(ang - 6) < 0.5) {
                float ox, oy, y;
                project(game->viewport, p->x, p->y, p->z, & ox, & oy);
                unproject_y(game->viewport, oy + dy, p->x, p->z, & y);
                p->y = floor(y / s + 0.1) * s;
            }
            else if (ang < 0.5 || ang > 7.5 || fabs(ang - 4) < 0.5) {
                ;
            }
            else {
                float ox, oy, x, z;
                project(game->viewport, p->x, p->y, p->z, & ox, & oy);
                unproject(game->viewport, ox + dx, oy + dy, p->y, & x, & z);
                if (fabs(x - p->x) > fabs(z - p->z)) {
                    p->x = floor(x / s + 0.1) * s;
                }
                else {
                    p->z = floor(z / s + 0.1) * s;
                }
            }
            game_recalc();
            return 1;
        }
    }
    if (released) {
        return 1;
    }
    return 0;
}
